/*
 * Name: common.js
 * Description: Service Common Common JS
 *
 * 1. Global Config
 * 2. Add Body Class
 * 3. Set Tel Anchor
 * 4. Big Menu
 * 5. Page Top
 * 6. Alert Modal
 * 7. Checkbox
 * 8. Radio
 * 9. Check All
 *
 *
 */



/*--------------------------
	Global Config
--------------------------*/
var Conf = function() {

	this.duration = 400;
	this.easing = 'easeOutQuart';
	this.ua = navigator.userAgent.toLowerCase();
	this.ver = navigator.appVersion.toLowerCase();
	this.browser = this.getBrowser();
	this.device = this.getDevice();

	this.init();
}


/* Init
--------------------------*/
Conf.prototype.init = function() {
	var that = this;
	$(function(){
		that.$window = $(window);
		that.$document = $('html, body');
		that.$body = $('body');
	});
}


/* Get Browser
--------------------------*/
Conf.prototype.getBrowser = function() {

	var ua = this.ua;
	var ver = this.ver;
	var browser = 'unknown';
	
	if ( ua.indexOf('msie') !== -1 ) {
		if ( ver.indexOf('msie 6.') !== -1 ) { browser = 'ie6'; }
		else if ( ver.indexOf('msie 7.') !== -1 ) { browser = 'ie7'; }
		else if ( ver.indexOf('msie 8.') !== -1 ) { browser = 'ie8'; }
		else if ( ver.indexOf('msie 9.') !== -1 ) { browser = 'ie9'; }
		else if ( ver.indexOf('msie 10.') !== -1 ) { browser = 'ie10'; }
		else { browser = 'ie'; }
	} else if ( ua.indexOf('trident/7') !== -1 ) {
		browser = 'ie11';
	} else if ( ua.indexOf('edge') !== -1 ) {
		browser = 'edge';
	} else if ( ua.indexOf('chrome') !== -1 ) {
		browser = 'chrome';
	} else if ( ua.indexOf('safari') !== -1 ) {
		browser = 'safari';
	} else if ( ua.indexOf('opera') !== -1 ) {
		browser = 'opera';
	} else if ( ua.indexOf('firefox') !== -1 ) {
		browser = 'firefox';
	}
	
	return browser;
}

/* Get Device 
--------------------------*/
Conf.prototype.getDevice = function() {

	var ua = this.ua;
	var device = 'unknown';

	if ( ua.indexOf('iphone') !== -1 ) {
		device = 'iphone';
	} else if ( ua.indexOf('ipad') !== -1 ) {
		device = 'ipad';
	} else if ( ua.indexOf('android') !== -1 ) {
		device = ua.indexOf('mobile') !== -1 ? 'android' : 'androidTablet';
	} else if ( ua.indexOf('win') !== -1 ) {
		device = 'windows';
	} else if ( ua.indexOf('mac') !== -1 ) {
		device = 'mac';
	} else if ( ua.indexOf('linux') !== -1 ) {
		device = 'linux';
	}
	return device;
}


/* Conditional Functions
--------------------------*/
Conf.prototype.isMobile = function() {
	if ( this.device === 'iphone' || this.device === 'android' ) return true;
	return false;
}
Conf.prototype.isIE9 = function() {
	if ( this.browser === 'ie9' ) return true;
	return false;
}
Conf.prototype.isIE10 = function() {
	if ( this.browser === 'ie10' ) return true;
	return false;
}
Conf.prototype.isFF = function() {
	if ( this.browser === 'firefox' ) return true;
	return false;
}


/* Get Instance
--------------------------*/
var conf = conf || new Conf();



/*--------------------------
	Add Body Class
--------------------------*/
$(function(){
	conf.$body.addClass( conf.device ).addClass( conf.browser );
});



/*--------------------------
	Big Menu
--------------------------*/
$(function(){
	var $gnav = $('.gnav');
	var $gnavItem = $('.gnav_item');
	var $gnavItemHead = $('.gnav_item_head');
	$gnavItemHead.on('mouseenter', function() {
		$gnavItem.removeClass('on');
		$(this).parent().addClass('on');
	});
	$gnav.on('mouseleave', function() {
		$gnavItem.removeClass('on');
	});
});



/*--------------------------
	Page Top
--------------------------*/
$(function(){
	var $btn = $('.footer_top a');

	var onScroll = function(e) {
		var s = $(this).scrollTop();
		if ( s > 900 ) {
			$btn.fadeIn( conf.duration );
		} else {
			$btn.fadeOut( conf.duration );
		}
	}

	var onClick = function(e) {
		e.preventDefault();
		$('html, body').stop().animate({
			scrollTop: 0
		}, conf.duration, conf.easing);		
	}

	conf.$window.on('scroll', onScroll);
	$btn.on('click', onClick);
});



/*--------------------------
	Alert Modal
--------------------------*/
$(function(){
	var $modal = $('.modal');
	var $modalContents = $modal.find('.modal_inner');
	var $close = $modal.find('.modal_close');

	function closeModal(e) {
		e.preventDefault();
		$modal.fadeOut( conf.duration, function() {
			$modal.remove();
		});
	}
	
	$close.on('click', closeModal);
});



/*--------------------------
	Checkbox
--------------------------*/
$(function(){

	// Config
	var $check = $('.checkbox').not('.disabled, .fixed');
	var $input = $check.find('input');
	var $reset = $('.reset');
	var activeClass = 'on';

	// Event Change
	$input.on('change', function() {
		var checked = $(this).prop('checked');
		if ( checked ) {
			$(this).parent( $check ).addClass(activeClass);
		} else {
			$(this).parent( $check ).removeClass(activeClass);
		}
	});

	// Event Reset
	$reset.on('click', function(e) {
		e.preventDefault();
		$check.removeClass('on');
		$input.prop('checked', false);
	});

});



/*--------------------------
	Radio
--------------------------*/
$(function(){

	// Config
	var $radio = $('.radio').not('.disabled, .fixed');
	var $input = $radio.find('input');
	var activeClass = 'on';

	// Event Change
	$input.on('change', function() {
		var name = $(this).prop('name');
		$input.filter('[name="' + name + '"]').parent( $radio ).removeClass( activeClass );
		$(this).parent( $radio ).addClass( activeClass );
	});

});




/*--------------------------
	Check All
--------------------------*/
$(function(){
	$trigger = $('.block_bukken_checkall .checkbox input');
	var activeClass = 'on';
	$trigger.off().on('change', function(e) {
		var checked = $(this).prop('checked');
		if ( checked ) {
			$trigger.parent().addClass(activeClass);
			$trigger.prop('checked', true);
			$(this).parents('.block_bukken_checkall').siblings('.block_bukkens').find('input').prop('checked', true).parent().addClass(activeClass);
		} else {
			$trigger.parent().removeClass(activeClass);
			$trigger.prop('checked', false);
			$(this).parents('.block_bukken_checkall').siblings('.block_bukkens').find('input').prop('checked', false).parent().removeClass(activeClass);
		}
	});
});