/*
 * Name: popup.js
 * Description: Popup UI Module Constructor
 *
 *
 */



/*--------------------------
	Constructor
--------------------------*/
var Popup = function() {

	this.$trigger = $('.js_popup');
	this.$close = $('.js_popup_close');
	this.$bodies = $('.js_popup_body');
	this.bodies = [];
	this.length = 0;

	this.init();
	this.listenTo();
}

Popup.prototype.init = function() {
	var that = this;
	this.$trigger.each(function() {
		that.bodies.push( this.hash );
	});
	this.length = that.bodies.length;
}

Popup.prototype.listenTo = function() {
	var that = this;
	this.$close.on('click', function(e) {
		e.preventDefault();
		that.close();
	});
	this.$trigger.on({
		'click': function(e) {
			e.preventDefault();
		},
		'mouseenter': function() {
			if ( !$(this).hasClass('disable') ) {
				that.close();
				var target = this.hash;
				$( target ).show();	
			}
		},
		'mouseleave': function(e) {
			if ( e.toElement.id.indexOf('popup') == -1 ) {
				that.$bodies.hide();	
			}
		}
	});
	this.$bodies.on({
		'mouseleave': function() {
			$(this).hide();
		}
	});
}

Popup.prototype.close = function() {
	for ( var i=0; i<this.length; i++ ) {
		$( this.bodies[i] ).hide();
	}
}




/*--------------------------
	Get Instance
--------------------------*/
$(function(){
	var popup = new Popup();
});