/*
 * Name: tab.js
 * Description: Tab UI Module Constructor
 *
 *
 */



/*--------------------------
	Constructor
--------------------------*/
var Tab = function() {

	// Get Elements
	this.$el = $('.js_tab');
	this.$head = this.$el.find('.js_tab_head');
	this.$panel = this.$el.find('.js_tab_body');

	this.panel = [];
	this.length = 0;
	this.activeIndex = 0;
	this.activeClass = 'active';
	this.hash = location.hash;

	this.init();
	this.listenTo();
}

// Init
Tab.prototype.init = function() {
	var that = this;

	// Set Panel
	this.$head.each(function() {
		that.panel.push( this.hash );
	});
	this.length = this.panel.length;	

	// Init Active Index
	if ( this.hash ) {
		this.activeIndex = this.getIndexByHash( this.hash );
	}
	this.show( this.activeIndex );
}

// Show The Active Panel
Tab.prototype.show = function( index ) {
	if ( isNaN( index ) ) return false;
	this.$head.parent().removeClass( this.activeClass ).eq( index ).addClass( this.activeClass );
	this.$panel.hide().eq( index ).show();
	this.activeIndex = index;
}

// Event
Tab.prototype.listenTo = function() {
	var that = this;
	this.$head.on('click', function(e) {
		e.preventDefault();
		var hash = this.hash;
		that.show( that.getIndexByHash( hash ) );
	});
}

// Util
Tab.prototype.getIndexByHash = function( hash ) {
	return this.panel.indexOf( hash );
}



/*--------------------------
	Get Instance
--------------------------*/
$(function(){
	var tab = new Tab();
});